<?php
class PortalAdmin
{
  private $dbo = null;
  public $zalogowany_adm = null;
  
  function __construct($host, $user, $pass, $db)
  {
    $this->dbo = $this->initDB($host, $user, $pass, $db);
    $this->zalogowany_adm = $this->getActualAdmin();
  }
  
  function initDB($host, $user, $pass, $db)
  {
    $dbo = new MyDB($host, $user, $pass, $db);
    if($dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: "
           . $dbo->connect_error;
      throw new Exception($msg);
    }
    return $dbo;
  }

  function getActualAdmin()
  {
    if(isset($_SESSION['zalogowany_adm'])){
      return $_SESSION['zalogowany_adm'];
    }
    else{
      return null;
    }
  }
  
  function setAdminMessage($komunikat)
  {
    $_SESSION['komunikat_adm'] = $komunikat;
  }
  
  function getAdminMessage()
  {
    if(isset($_SESSION['komunikat_adm'])){
      $komunikat = $_SESSION['komunikat_adm'];
      unset($_SESSION['komunikat_adm']);
      return $komunikat;
    }
    else {
      return null;
    }
  }
  
  function login()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostały przekazane parametry
    if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["haslo"];
    
    //Sprawdzenie długości przekazanych ciągów
    //Dla kodowania jednobajtowego
    //$userNameLength = strlen($user);
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    $userNameLength = mb_strlen($user, 'UTF8');
    $userPassLength = mb_strlen($pass, 'UTF8');
    
    if($userNameLength < 3 || $userNameLength > 20 ||
       $userPassLength < 6 || $userPassLength > 40){
      return LOGIN_FAILED;
    }
  
    //Zabezpieczenie znaków specjalnych w parametrach
    $user = $this->dbo->real_escape_string($user);
    
    //Wykonanie zapytania sprawdzającego poprawność danych
    $query = "SELECT Haslo, Nazwa, Id "
           . "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
      return SERVER_ERROR;
    }

    //Sprawdzenie wyników zapytania
    if($result->num_rows != 1){
      //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników
      return LOGIN_FAILED;
    }
    else{
      $row = $result->fetch_row();
      $pass_db = $row[0];
      //Wersja bez kodowania haseł
      if($pass != $pass_db){
      //Wersja z kodowaniem haseł
      //if(crypt($pass, $pass_db) != $pass_db){
        return LOGIN_FAILED;
      }
      else{
        $_SESSION['zalogowany_adm'] = new User($row[2], $row[1]);
      }
      
      //Obsługa przywilejów
      
      //Utworzenie zmiennej sesji, jeśli konieczne
      /*if(!isset($_SESSION['przywileje'])){
        $_SESSION['przywileje'] = array();
      }*/
      
      //Zapytanie pobierające dane.
      $query = "SELECT PrzywilejId FROM Uzytkownicy_Przywileje "
             . "WHERE UserId=" . $row[2];
      
      //Zapis danych o przywilejach z zmiennej sesji
      if($result = $this->dbo->query($query)){
         while($row = $result->fetch_row()){
           $_SESSION['zalogowany_adm']->przywileje[$row[0]] = true;
         }
      }
      
      //Rezultat logowania
      if(isset($_SESSION['zalogowany_adm']->przywileje[1])){
        return LOGIN_OK;
      }
      else{
        return NO_ADMIN_RIGHTS;
      }
    }
  }
  
  function logout()
  {
    $this->zalogowany_adm = null;
    if(isset($_SESSION['zalogowany_adm'])){
      unset($_SESSION['zalogowany_adm']);
      //unset($_SESSION['przywileje']);
      /*if (isset($_COOKIE[session_name()])){
        setcookie(session_name(), '', time() - 3600);
      }
      session_destroy();*/
    }
  }
  
  function usersAdmin()
  {
    if(!isset($this->zalogowany_adm->przywileje[2])){
      echo 'Brak uprawnień';
      return;
    }

    $ua = new UsersAdmin($this->dbo);
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    switch($wtd){
      case 'showEditForm':
        $ua->showEditForm('edit');
        break;
      case 'showAddForm':
        $ua->showEditForm('add');
        break;
      case 'showSearchForm':
        $ua->showSearchForm();
        break;
      case 'addUser' :
        $id = 0;
        switch($ua->editUser('add', $id)){
          case ACTION_OK :
            $this->setAdminMessage("Użytkownik został dodany (id = $id).");
            break;
          case INVALID_USER_ID:
            $this->setAdminMessage('Nieprawidłowy identyfikator użytkownika.');
            break;
          case INVALID_USER_NAME:
            $this->setAdminMessage('Nieprawidłowa nazwa użytkownika.');
            break;
          case USER_NAME_ALREADY_EXISTS:
            $this->setAdminMessage('Użytkownik o podanej nazwie istnieje w bazie.');
            break;
          case USER_ID_ALREADY_EXISTS:
            $this->setAdminMessage('Użytkownik o podanym id istnieje w bazie.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Błąd serwera. Użytkownik nie został dodany.');
        }
        header('Location:index.php?action=usersAdmin&wtd=showAddForm');
        break;
      case 'modifyUser' :
        $id = 0;
        switch($ua->editUser('edit', $id)){
          case ACTION_OK :
            $this->setAdminMessage('Dane zostały zmienione.');
            break;
          case INVALID_USER_ID:
            $this->setAdminMessage('Nieprawidłowy identyfikator użytkownika.');
            break;
          case INVALID_USER_NAME:
            $this->setAdminMessage('Nieprawidłowa nazwa użytkownika.');
            break;
          case FORM_DATA_MISSING:
            $this->setAdminMessage('Brak danych z formularza.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Błąd serwera. Danie nie zostały zmienione.');
        }
        header("Location:index.php?action=usersAdmin&wtd=showEditForm&id=$id");
        break;
      case 'searchUser' :
        $ua->showSearchForm();
        switch ($ua->searchUser()){
          case ACTION_OK:
            break;
          case USER_NOT_FOUND:
            echo 'Nie znaleziono użytkownika.';
            break;
          case FORM_DATA_MISSING :
            echo 'Brak danych z formularza.';
            break;
          case INVALID_USER_ID :
            echo 'Błędny identyfikator użytkownika.';
            break;
          case INVALID_USER_NAME :
            echo 'Błędna nazwa użytkownika.';
            break;
          case SERVER_ERROR:
          default:
            echo 'Błąd serwera.';
        }
        break;
      case 'deleteUser':
        switch($ua->deleteUser()){
          case ACTION_OK:
            $this->setAdminMessage('Użytkownik został usunięty.');
            break;
          case USER_NOT_FOUND:
            $this->setAdminMessage('Brak użytkownika o podanym id.');
            break;
          case INVALID_USER_ID:
            $this->setAdminMessage('Nieprawidłowy identyfikator użytkownika.');
            break;
          case SERVER_ERROR:
          default:
           $this->setAdminMessage('Błąd serwera.');
        }
        header('Location:index.php?action=usersAdmin&wtd=showList');
        break;
      case 'showList' :
      default:
        $ua->showList(ROWS_ON_PAGE);
    }
  }
  
  function getHeaderLinks(){
    $str = '';
    if($this->zalogowany_adm){
      if(isset($this->zalogowany_adm->przywileje[2])){
        $str .= '<a href="index.php?action=usersAdmin">'
             . 'Zarządzanie użytkownikami</a> | ';
      }
      if(isset($this->zalogowany_adm->przywileje[3])){
        $str .= '<a href="index.php?action=newsAdmin">'
             . 'Zarządzanie newsami</a> | ';
      }
      if(isset($this->zalogowany_adm->przywileje[4])){
        $str .= '<a href="index.php?action=subscriptionsAdmin">'
             . 'Zarządzanie subskrypcjami</a> | ';
      }
    }
    return $str;
  }
  
  function newsAdmin()
  {
    if(!isset($this->zalogowany_adm->przywileje[3])){
      echo 'Brak uprawnień';
      return;
    }

    $na = new NewsAdmin($this->dbo);
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    switch($wtd){
      case 'showEditForm':
        $na->showEditForm('edit');
        break;
      case 'showAddForm':
        $na->showEditForm('add');
        break;
      case 'showSearchForm':
        $na->showSearchForm();
        break;
      case 'addNews' :
        switch($na->editNews('add')){
          case ACTION_OK :
            $this->setAdminMessage('News został dodany.');
            break;
          case INVALID_NEWS_ID:
            $this->setAdminMessage('Nieprawidłowy identyfikator news.');
            break;
          case NEWS_ID_ALREADY_EXISTS:
            $this->setAdminMessage('News o podanym id istnieje w bazie.');
            break;
          case NOT_ENOUGH_RIGHTS:
            $this->setAdminMessage('Brak uprawnień do edycji.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Błąd serwera. Użytkownik nie został dodany.');
        }
        header('Location:index.php?action=newsAdmin&wtd=showAddForm');
        break;
      case 'modifyNews' :
        $id = 0;
        switch($na->editNews('edit', $id)){
          case ACTION_OK :
            $this->setAdminMessage('Dane zostały zmienione.');
            break;
          case INVALID_NEWS_ID:
            $this->setAdminMessage('Nieprawidłowy identyfikator news.');
            break;
          case NOT_ENOUGH_RIGHTS:
            $this->setAdminMessage('Brak uprawnień do edycji.');
            break;
          case FORM_DATA_MISSING:
            $this->setAdminMessage('Brak danych z formularza.');
            break;
          case SERVER_ERROR :
          default:
            $this->setAdminMessage('Błąd serwera. Danie nie zostały zmienione.');
        }
        header("Location:index.php?action=newsAdmin&wtd=showEditForm&id=$id");
        break;
      case 'searchNews' :
        $na->showSearchForm();
        switch ($na->searchNews()){
          case ACTION_OK:
            break;
          case NEWS_NOT_FOUND:
            echo 'Nie znaleziono newsa.';
            break;
          case FORM_DATA_MISSING :
            echo 'Brak danych z formularza.';
            break;
          case INVALID_NEWS_ID :
            echo 'Błędny identyfikator newsa.';
            break;
          case SERVER_ERROR:
          default:
            echo 'Błąd serwera.';
        }
        break;
      case 'deleteNews' :
        switch($na->deleteNews()){
          case ACTION_OK:
            $this->setAdminMessage('News został usunięty.');
            break;
          case NEWS_NOT_FOUND:
            $this->setAdminMessage('Brak newsa o podanym id.');
            break;
          case INVALID_NEWS_ID:
            $this->setAdminMessage('Nieprawidłowy identyfikator newsa.');
            break;
          case NOT_ENOUGH_RIGHTS:
            $this->setAdminMessage('Brak uprawnień.');
            break;
          case SERVER_ERROR:
          default:
           $this->setAdminMessage('Błąd serwera.');
        }
        header('Location:index.php?action=newsAdmin&wtd=showList');
        break;
      case 'showList' :
      default:
        $na->showList(ROWS_ON_PAGE);
    }
  }
  
  function subscriptionsAdmin()
  {
    //Sprawdzenie uprawnień
    if(!isset($this->zalogowany_adm->przywileje[4])){
      echo 'Brak uprawnień';
      return;
    }
    
    $sa = new SubscriptionsAdmin($this->dbo);
    
    //Sprawdzenie, czy został przekazany parametr wtd
    if(isset($_GET['wtd'])){
      $wtd = $_GET['wtd'];
    }
    else{
      $wtd = 'showList';
    }
    
    //Wywołanie metod w zależności od wartości zapisanej w $wtd
    switch($wtd){
      case 'getEmailsList':
        switch ($sa->getEmailsList()){
          case ACTION_OK :
            break;
          case SERVER_ERROR :
          default :
            $this->setAdminMessage('Błąd serwera. Lista nie jest dostępna.');
            header('Location:index.php?action=subscriptionsAdmin&wtd=showList');
        }
        break;
      case 'showList':
      default:
        switch($sa->showList()){
          case ACTION_OK :
            break;
          case SERVER_ERROR:
          default:
           echo 'Błąd serwera. Lista nie jest dostępna.';
        }
    }
  }
  
}
?>